
#ifndef _1_CRYS_EXT_ATP_TST_Defines_h_H
#define _1_CRYS_EXT_ATP_TST_Defines_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Dec 02 11:21:17 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_Ext_ATP_TST_Defines.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"

/************************ Global Data **************************/
extern CRYSError_t      TST_ATP_Error;
extern DxUint8_t	    TST_ATP_EncryptDecryptFlag;
extern CRYS_Version_t   TST_ATP_CRYS_version;
/************************ Defines ******************************/
#define TESTPASS 	    0
#define TESTFAIL 	    1
/* define for enabling performance tests */
/*----------------------------------------*/
#define TST_ENABLE_PERFORMANCE_TST 0
#if TST_ENABLE_PERFORMANCE_TST
#define TICKS_PER_SECOND 1
#define TST_DEVIDE_TO_CONVERT_BYTES_TO_MBIT  (1000000/8)
extern DxUint32_t TST_Timer;
extern DxUint32_t TST_PerformanceDataSize;
extern float TST_PerformanceMasure;
#endif
/* Print levels */
/*--------------*/
#define CRYS_ATP_TST_MSG 		10
#define CRYS_ATP_TST_DBG_HIGH 	20
#define CRYS_ATP_TST_DBG_MED	30
#define CRYS_ATP_TST_DBG_LOW 	40

/* Defines for tests Behavior */
/*----------------------------*/

#define CRYS_ATP_TST_EXIT_ON_ERROR  1
#define CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR 1
#define TST_FILE_PATH_LENGTH       1000

/*if the engine is SOFT then then define is 1 else is 0 */
#define TST_IF_RESET_IS_VOID_FUNCTION   !LLF_RND_ENGINE_TYPE

#define FailureFunctionName_K_Size TST_FUNC_STRING_LEN

/* Test detailed defines */
/*-----------------------*/
/*General*/
/*-------*/
#define TST_FAIL         1
#define TST_PASS         0
#define TST_ENCRYPT      0 
#define TST_DECRYPT      1
#define TST_NULL_PTR     0
#define TST_ZERO_DATA 	 0
#define TST_NOT_DEVIDE_8 1

#define TST_NAME_STRING_LEN 150
#define TST_DATA_VEC_SIZE_IN_WORDS 4
#define TST_DATA_BLOCK 512
#define TST_MAX_DATA_VEC_SIZE_IN_BYTS 1536
#define TST_IV_NULL  0
#define TST_IV_VALUE 1


#define TST_EXTERNAL_KEYPAIR 1

#ifdef __cplusplus
}
#endif
 
#endif

